#include "Dialog.h"
#include "resource.h"

INT CDialogClass::m_nPolygonType;
FLOAT CDialogClass::m_fTimerVal;
BOOL CDialogClass::m_bDefaultTimer;
BOOL CDialogClass::m_bNoTimer;

BEGIN_MESSAGE_MAP( CDialogClass, CDialog )
	ON_BN_CLICKED(IDC_CHECK1, OnNewRegularPolygon)
	ON_BN_CLICKED(IDC_CHECK2, OnNewPolygonFigure)
	ON_BN_CLICKED(IDC_CHECK3, OnSuperposePolygon)
	ON_COMMAND(IDC_CREATE_POLYGON, CreatePolygon)
	ON_COMMAND(IDC_CREATE_STAR_FIGURE, CreatePolygon)
	ON_BN_CLICKED(IDC_DEFAULT_TIMER, OnDefaultTimer)
	ON_BN_CLICKED(IDC_NOTIMER, OnNoTimer)
END_MESSAGE_MAP()

CDialogClass::CDialogClass( CWnd *pParentWnd ) 
: CDialog( IDD_DIALOG1, pParentWnd )
{
	mf = new CMainFrm();
	m_bDefaultTimer = 0;
	m_bNoTimer = 0;
}

CDialogClass::~CDialogClass()
{
	delete mf;
}

void CDialogClass::OnNewRegularPolygon() {
	dlg1 = new CDialogClass;
	dlg1->Create(IDD_DIALOG3);
	dlg1->ShowWindow(SW_SHOW);
	mf->SetPolygonType(0);
	m_nPolygonType = 0;
	EndDialog(0);
}

void CDialogClass::OnNewPolygonFigure() {
	dlg2 = new CDialogClass;
	dlg2->Create(IDD_DIALOG4);
	dlg2->ShowWindow(SW_SHOW);
	mf->SetPolygonType(1);
	m_nPolygonType = 1;
	EndDialog(0);
}
	
void CDialogClass::OnSuperposePolygon() {
	dlg1 = new CDialogClass;
	dlg1->Create(IDD_DIALOG3);
	dlg1->ShowWindow(SW_SHOW);
	mf->SetPolygonType(2);
	m_nPolygonType = 2;
	EndDialog(0);
}

void CDialogClass::OnDefaultTimer() {
	mf->SetDefaultTimer(1);
	m_bDefaultTimer = 1;
}

void CDialogClass::OnNoTimer() {
	m_bNoTimer = 1;
}

// extract the users inputs from the current dialog box
void CDialogClass::CreatePolygon() {
	EndDialog(0);
	CString Buffer;
	CEdit *pEdit = (CEdit*)GetDlgItem(IDC_NUM_SIDE);
	pEdit->GetWindowText(Buffer);
	m_nNumOfSides = atoi(Buffer);
	m_bDrawPolygon = 1;
	if(m_nPolygonType == 1) {
		pEdit = (CEdit*)GetDlgItem(IDC_DENSITY);
		pEdit->GetWindowText(Buffer);
		m_nDensity = atoi(Buffer);
		mf->SetDensity(m_nDensity);
	}
	if(!m_bNoTimer && !m_bDefaultTimer) {
		pEdit = (CEdit*)GetDlgItem(IDC_TIMER_VAL);
		pEdit->GetWindowText(Buffer);
		m_fTimerVal = atof(Buffer);
		mf->SetTimerVal(m_fTimerVal);
	}
	mf->SetTimerVal(m_fTimerVal);
	mf->SetPolygonDrawing(m_bDrawPolygon);
	mf->SetNumOfSides(m_nNumOfSides);
}



